# Flawless Nuke Tools

Refactored menu system for loading gizmos and toolsets in Foundry Nuke.

## Structure
```
flawless_nuke_tools/
  menu.py        # Menu builder (import side-effect builds menu)
  flawless/      # Content root scanned for gizmos/toolsets
    Colour/ ...
    Time/   ...
    Toolsets/    # .nk files loaded via loadToolset / nodePaste fallback
    Transform/   ...
    Utilities/   ...
    icons/       # logo candidate(s)
```

## Installation
Add the folder containing `init.py` to your `NUKE_PATH`.
Example:
```bash
export NUKE_PATH="/path/to/flawless_nuke_tools:$NUKE_PATH"
```

or

Inside of your init.py from .nuke, add the path to the flawless_nuke_tool. If the file doesn't exist create the file called "init.py"
```python
nuke.pluginAddPath(['./flawless_nuke_tools'])
```
On launch, Nuke will import `init.py`, which imports `menu.py` and builds the Flawless menu.

## Usage Notes
* Gizmos: Selecting a gizmo adds its parent folder to `nuke.pluginPath()` before creating.
* Toolsets: Files inside top-level `Toolsets` folder use `nuke.loadToolset()` first; fallback to `nodePaste`.
* Unknown file types: Adds a command to reveal the file in Finder/Explorer.
* Hidden / reserved folders skipped: `.something`, `__pycache__`, `icons`, `scripts`.

## Public API
```python
from flawless_nuke_tools import menu
menu.build_menu()  # Rebuild manually if content changes
```

## Extending
Subclass `MenuBuilder` or modify `CONFIG` dataclass for new skip folders or menu name.

## Changes vs Original
* Removed scattered globals; introduced `Config` dataclass and `MenuBuilder` class.
* Centralized plugin path tracking.
* Added type hints and safe fallbacks when imported outside Nuke.
* Added `init.py` for auto-loading.
* Simplified error handling and messages.

## Troubleshooting
If the menu does not appear:
1. Confirm `NUKE_PATH` contains the directory with `init.py`.
2. Open Script Editor and search for `[Flawless]` messages.
3. Verify `flawless/` folder exists within the repository.
4. Ensure permissions allow reading the gizmo/toolset files.
